unit Strom;

interface
 type
  tPole = array of integer;
  tPriznak = (nic, zam, list, nejde);

  ukUzel = ^tUzel;
  tUzel = record
    hodnota: integer;
    potomci: array of ukUzel;
  end;

 procedure StrNaPole(str: string; var pole: tPole);
 function VytvorStrom(pole: tPole): ukUzel;
 function QVyvazeny(const Strom: ukUzel): boolean;
 function QJdePostavit(Pole:tPole; var index:integer): boolean;
 procedure PorovnejStromy(A,B: ukUzel; var priznak: tPriznak; var p1,p2: integer);

implementation
uses SysUtils, math;

procedure StrNaPole(str: string; var pole: tPole);
var i,pocet: integer; s:string;
begin
  i:= 1;
  s:='';
  pocet:=0;
  SetLength(pole,pocet);
  while i <= length(str) do
  begin
    while str[i] = ' ' do inc(i);
    while (str[i] <> ' ') and (i <= length(str)) do begin s:=s + str[i]; inc(i); end;
    inc(Pocet); SetLength(pole,pocet);
    pole[pocet-1]:= StrToInt(s);
    s:='';
  end;
end;

function VytvorUzel(pole: tPole; var index: integer): ukUzel;
var Uzel: ukUzel; i,hod,pSynu: integer;
begin
  hod:= pole[index]; inc(index);
  pSynu:= pole[index];  inc(index);
  new(uzel);
  SetLength(uzel^.potomci,pSynu);
  Uzel^.hodnota:= hod;
  for i:=0 to pSynu-1 do Uzel^.potomci[i]:= VytvorUzel(pole,index);
  result:= uzel;
end;

function VytvorStrom(pole: tPole): ukUzel;
var i:integer;
begin
  i:=0;
  result:= VytvorUzel(pole,i);
end;

function PocitejHloubku(Uzel: ukUzel; PocHloubka: integer): integer;
var i: integer;
begin
 result:= 0;
 if length(Uzel^.potomci) > 0 then
  for i:= 0 to high(Uzel^.potomci) do
   result:= Max(result,PocitejHloubku(Uzel^.potomci[i],PocHloubka+1))
 else result:= PocHloubka + 1;
end;

function QVyvazeny(const Strom: ukUzel): boolean;
var i,j: Integer;
begin
  result:= true;
  for i:= low(Strom^.potomci) to high(Strom^.potomci) do
   for j:= low(Strom^.potomci) to high(Strom^.potomci) do
   if i <> j then {porovnej hloubku 2 ruznych vetvi}
     result:= result and (Abs(PocitejHloubku(Strom^.potomci[i],0)-PocitejHloubku(Strom^.potomci[j],0)) <= 1);
 if result then {tento uzel je vyvazeny - zkus jeho syny}
  for i:= 0 to high(Strom^.potomci) do
   result:= result and QVyvazeny(Strom^.potomci[i]);
end;


function QJdePostavit(Pole:tPole; var index:integer): boolean;
var i, pocet: integer;
begin
  inc(index,2);
  result:= true;
  if length(pole) mod 2 <> 0 then result:= false;
  if length(pole) < index then result:= false;
  pocet:= pole[index];
  for i:= 1 to pocet do result:= result and QJdePostavit(pole,index);

end;
                                               

procedure PorovnejStromy(A,B: ukUzel; var priznak: tPriznak; var p1,p2: integer);
var zamena, chybiList : boolean;
    zamena1,zamena2: integer;

 function PorovnejUzel(A,B: ukUzel): boolean;
 var i,j: integer; Pom1,Pom2: ukUzel; jev: boolean;

 begin
  Result:=A^.hodnota = B^.hodnota;
  if not Result then {jsou prohozene uzly}
   begin
    if (not zamena) and (not chybiList) then  {jedna se o prvni zmenu}
     begin
      Zamena1:= A^.hodnota; Zamena2:= B^.hodnota; result:= true; zamena:= true;
     end
    else {druha zamena - porovnej uzly}
     result:= (Zamena1 = B^.hodnota) and (Zamena2 = A^.hodnota);
   end;

   if Length(A^.potomci) = Length(B^.potomci) then {listy maji stejne synu}
    begin
     for i:= low(A^.potomci) to high(A^.potomci) do  {zpracuji se synove}
      if result then result:= result and PorovnejUzel(A^.potomci[i],B^.potomci[i]);
    end
   else
    if (not chybiList) and (not zamena) and  {chybi jeden syn}
     (Abs(Length(A^.potomci) - Length(B^.potomci)) = 2) then
     begin
      if Length(A^.potomci) > Length(B^.potomci) then {ureceni kteremu uzlu chybi syn}
       begin Pom1:= A; Pom2:= B end
      else begin Pom1:= B; Pom2:= A end;
      for i:= Low(A^.potomci) to High(Pom1^.potomci) do
      begin
        jev:= false;
        for j:= 0 to high(Pom2^.potomci) do
        begin
          jev:= Pom1^.potomci[i].hodnota = Pom2^.potomci[j].hodnota;
          if jev then break;
        end;
        if not jev then {nalezen syn ktery chybi}
        begin
         if (Length(Pom1^.potomci[i]^.potomci) = 0) and (not chybiList) and (not zamena) then
          begin
           ChybiList:= true;
           p1:= Pom1.potomci[i].hodnota;
           result:= true;
          end
         else result:= false;
        end
     end
    end
    else result:= false;
 end;

begin
  zamena:= false; chybiList:= false;
  if PorovnejUzel(A,B) then
  begin
    priznak:= nic;
    if zamena then
    begin
      if zamena1 < zamena2 then begin p1:= zamena1; p2:= zamena2 end
       else begin p1:= zamena2; p2:= zamena1 end; {vypis nejdriv nizsi hodnotu uzlu}
      priznak:= zam
    end;
    if chybiList then begin p1:= -1 * p1; priznak:= list end;
  end;
end;

end.
